﻿//////////////////////////////////////////////
// ConstantBuffer.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "ShaderPassMemorySlot.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <vector>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ConstantBuffer : public nkExport::Exportable
	{
		public :

			// Getters
			ShaderPassMemorySlot* getPassMemorySlot (unsigned int index) ;
			ShaderPassMemorySlot* getPassMemorySlotReadOnly (unsigned int index) const ;

			// Manipulations slots
			ShaderPassMemorySlot* addPassMemorySlot () ;
			void changePassMemorySlotOrder (unsigned int fromIndex, unsigned int toIndex) ;
			void deletePassMemorySlot (unsigned int index) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

			// Operators
			ConstantBuffer& operator= (const ConstantBuffer&) = delete ;

		protected :

			// Fonctions
			// Constructors
			ConstantBuffer (System* system) noexcept ;
			ConstantBuffer (const ConstantBuffer&) = delete ;

			// Allocations
			virtual ShaderPassMemorySlot* _allocatePassMemorySlot () = 0 ;

		protected :
		
			// Attributes
			std::vector<nkMemory::UniquePtr<ShaderPassMemorySlot>> _slots ;
			System* _system ;
			bool _dirtyData ;
	} ;
}